local iHeight = ... or THEME:GetMetric(Var "LoadingScreen","HeaderFallbackHeight");
assert(iHeight);

local t = Def.ActorFrame {};
-- Streams, Background
t[#t+1] = Def.ActorFrame {
	Def.Quad {
		InitCommand=cmd(zoomto,SCREEN_WIDTH,iHeight);
		OnCommand=cmd(fadebottom,0.5);
	};
	LoadActor("texture 1") .. {
		InitCommand=cmd(zoomto,SCREEN_WIDTH,iHeight;customtexturerect,0,0,SCREEN_WIDTH/256,iHeight/256);
		OnCommand=cmd(texcoordvelocity,-0.25,0;diffusealpha,0.4);
	};
	LoadActor("texture 2") .. {
		InitCommand=cmd(zoomto,SCREEN_WIDTH,iHeight;customtexturerect,0,0,SCREEN_WIDTH/256,iHeight/256);
		OnCommand=cmd(texcoordvelocity,0.125,0;diffusealpha,0.4);
	};
	LoadActor(THEME:GetPathG("","swipes")) .. {
		InitCommand=cmd(zoomto,SCREEN_WIDTH,iHeight;customtexturerect,0,0,SCREEN_WIDTH/(256*1.5),iHeight/100);
		OnCommand=cmd(texcoordvelocity,-0.35,0;diffuse,0,0,0,0.1;fadebottom,1);
	};
	LoadActor(THEME:GetPathG("","swipes")) .. {
		InitCommand=cmd(zoomto,SCREEN_WIDTH,iHeight;customtexturerect,0,0,SCREEN_WIDTH/(256*2.5),iHeight/200);
		OnCommand=cmd(texcoordvelocity,-0.35,0;diffuse,0,0,0,0.2;fadetop,1);
	};

	Def.Quad {
		InitCommand=cmd(zoomto,SCREEN_WIDTH,iHeight);
		OnCommand=cmd(diffuse,DarkColor(cBlue);blend,"BlendMode_Add");
	};

	LoadActor("seperator") .. {
		InitCommand=cmd(y,iHeight/2;zoomtowidth,SCREEN_WIDTH);
	};
	
	LoadFont("Common", "Normal") ..{
		Name="HeaderText";
		InitCommand=cmd(x,-SCREEN_CENTER_X+8;y,-4;horizalign,left;NoStroke;shadowlength,1;shadowcolor,color("#000044");settext,ScreenString("HeaderText");diffusebottomedge,color("#EEEEEE"));
	};

	UpdateScreenHeaderMessageCommand=function(self,params)
		local header = self:GetChild("HeaderText");
		header:settext( params.Header );
	end;
};

t.BeginCommand=cmd(y,iHeight/2);
return t;